clear all

* Set folder

cd ..\Outputs

* Use shocks database constructed before

use SHOCKS, clear

* Merge with IMF revisions, which are 729 observations

capture drop _merge
merge 1:1 ISO year semester using IMFREV.dta
rename _merge mergeIMF1

capture drop _merge
merge 1:1 ISO year semester using IMFHPMA.dta
rename _merge mergeIMF2

* Merge with OECD revisions, which are 1734 observations

capture drop _merge
merge 1:1 ISO year semester using OECREV.dta
rename _merge mergeOEC1

capture drop _merge
merge 1:1 ISO year semester using OECHPMA.dta
rename _merge mergeOEC2

* Merge with Consensus Economics revisions, which are 604 observations

capture drop _merge
merge 1:1 ISO year semester using CONREV.dta
drop if _merge==2
rename _merge mergeCON1

capture drop _merge
merge 1:1 ISO year semester using CONACT.dta
drop if _merge==2
rename _merge mergeCON2

* Drop some irrelevant variables

drop tt x

* Label all variables by group

* Shocks to growth of potential constructed from IMF's WEOs:

label var SC "Shocks to growth of potential in lcu, IMF WEO, semester"
label var S4 "Shocks to growth of potential in lcu, 4 year sum, WEO, semester"

* Shocks to the growth rate of potential output constructed from OECD's EOs:

label var REVOECD1 "1 year ahead revisions to growth of pot, OECD WEO, semester"
label var REVOECD5 "Sum 5 year ahead revs to growth pot, OECD WEO, semester"

* Shocks to different variables (GDP, CON, etc.) different number of years ahead
* (1, sum of 2-5, 6, 7) and of different types (consensus, high, low, standard
* deviation) constructed from Consensus economics reports:

foreach v of varlist REVI????? {

	local period=substr(`"`v'"',5,1)
	local typeva=substr(`"`v'"',6,1)
	local variab=substr(`"`v'"',7,3)

	if "`period'"=="0"      local longp=`"1 year"'
	if "`period'"=="1"      local longp=`"Sum of 2-5 years"'
	if "`period'"=="2"      local longp=`"6 years"'
	if "`period'"=="3"      local longp=`"7 years"'

	if "`typeva'"=="C"      local longt=`"Consensus"'
	if "`typeva'"=="H"      local longt=`"High"'
	if "`typeva'"=="L"      local longt=`"Low"'
	if "`typeva'"=="S"      local longt=`"Std. Dev."'

	if "`variab'"=="GDP"    local longv=`"GDP"'
	if "`variab'"=="CON"    local longv=`"Consumption"'
	if "`variab'"=="INV"    local longv=`"Investment"'
	if "`variab'"=="PRO"    local longv=`"Production"'
	if "`variab'"=="CPI"    local longv=`"Consumer Price Inflation"'
	if "`variab'"=="CAC"    local longv=`"Current Account"'
	if "`variab'"=="BON"    local longv=`"Bond Yield"'
	if "`variab'"=="DPI"    local longv=`"Disposable Personal Income"'
	if "`variab'"=="NPP"    local longv=`"Nominal Pre-Tax Profits"'
	if "`variab'"=="EMC"    local longv=`"Employment Costs"'
	if "`variab'"=="3MT"    local longv=`"3 Month Treasury Bill Rate"'
	if "`variab'"=="RPI"    local longv=`"Retail Price Inflation"'
	if "`variab'"=="3MI"    local longv=`"3 Month Interbank Rate"'	

	label var `v' "`longt' revision for `longv' `longp' ahead"

}

* Merge variables:

label var mergeIMF1 "Merge indicator for IMF revisions"
label var mergeOEC1 "Merge indicator for OECD revisions"
label var mergeCON1 "Merge indicator for Consensus Economics revisions"

label var mergeIMF2 "Merge indicator for IMF HP and MA"
label var mergeOEC2 "Merge indicator for OECD HP and MA"
label var mergeCON2 "Merge indicator for Consensus Economics Actual Data"

* Label new variables that are growth numbers for actual and potential output
* as well as consumption and investment (Y, P, C, I), from different sources
* (IMF, OEC, CON), at different horizons (t,...,t+4) given in different periods
* (t-1,t,T)

foreach v of varlist G????tp?g* {

	local typeva=substr(`"`v'"',2,1)
	local instit=substr(`"`v'"',3,3)	
	local horizo=substr(`"`v'"',8,1)
	local givena=substr(`"`v'"',10,3)

	if "`typeva'"=="Y"      local longt=`"Actual Output growth"'
	if "`typeva'"=="P"      local longt=`"Potential Output growth"'
	if "`typeva'"=="C"      local longt=`"Consumption growth"'
	if "`typeva'"=="I"      local longt=`"Investment growth"'
	if "`typeva'"=="J"      local longt=`"Industrial Production growth"'
	if "`typeva'"=="D"      local longt=`"CPI growth"'
	if "`typeva'"=="B"      local longt=`"Bond Yield level (in %)"'
	
	if "`instit'"=="IMF"    local longi=`"IMF"'
	if "`instit'"=="OEC"    local longi=`"OECD"'
	if "`instit'"=="COC"    local longi=`"C.E. consensus estimate"'
	if "`instit'"=="COH"    local longi=`"C.E. high estimate"'
	if "`instit'"=="COL"    local longi=`"C.E. low estimate"'
	if "`instit'"=="COS"    local longi=`"C.E. standard deviation"'

	if "`givena'"=="tm1"    local gi=`"t minus 1"'
	if "`givena'"=="tm0"    local gi=`"t"'
	if "`givena'"=="tp1"    local gi=`"t plus 1"'
	if "`givena'"=="tp2"    local gi=`"t plus 2"'
	if "`givena'"=="tp3"    local gi=`"t plus 3"'
	if "`givena'"=="T"      local gi=`"T"'	

	label var `v' "`longi' estimate for `longt' in t+`horizo' given in `gi'"

}

foreach v of varlist G????lcu {
	local typeva=substr(`"`v'"',2,1)
	local instit=substr(`"`v'"',3,3)	
	if "`typeva'"=="Y"      local longt=`"Actual Output growth"'
	if "`typeva'"=="P"      local longt=`"Potential Output growth"'
	if "`instit'"=="IMF"    local longi=`"IMF"'
	if "`instit'"=="OEC"    local longi=`"OECD"'
	label var `v' "`longi' estimate for real `longt' in real time"
}

* Generate variables for panel structure

egen con=group(ISO)
label var con "Numeric country code"

sort ISO year semester
by ISO: gen tt=_n
label var tt "Time within panel"

* Set panel

xtset con tt
drop merge*

save SEMESTER, replace

replace GPIMFtp0gtm0=GPIMFtp0gtm0*100
replace GPOECtp0gtm0=GPOECtp0gtm0*100

* Produce Table 1

summ GPIMFtp0gtm0 GPOECtp0gtm0 GYCOCtp6gtm0
corr GPIMFtp0gtm0 GPOECtp0gtm0 GYCOCtp6gtm0
